/**
 * @file Drv_USIM.c
 * @author 吳星萍 (iris@e-besthealth.com)
 * @brief USIM0 USIM1 驅動程序
 * @version 0.1
 * @date 2020-06-27
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH67F5362/1.1
 */
#include "Project_Global.h"
#include "BH67F5362.h"
#include "Drv_UART.h"
#include "Drv_GPIO.h"

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用變量 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
volatile struct DrvUartFormat_t DrvUart0Format;
volatile struct DrvUartFormat_t DrvUart1Format;
volatile bit    Txfinish_flag=0;
void Drv_UART0_Init()
{
	SET_UARTn_Format_D8_NONE_S1(0); // 數據傳輸格式設定
	SET_UARTn_BAUDRATE_9600(0);	// 波特率設定
	SET_UARTn_FIFO_BYTE_1(0);//FIFO觸發等級設定
	SET_UARTn_ADDRESS_DISABLE(0);
	SET_UARTn_RECEIVER_IE_ENABLE(0);
	SET_UARTn_TRANSMITTER_IE_ENABLE(0);
	SET_UARTn_TRANSMITTER_EMPTY_ENABLE(0);
	SET_UARTn_ENABLE(0);
	_emi = 1;
	// UART IO
	SET_PA6_RX0();
	SET_PA7_TX0();
	DrvUart0Format.RxLength = 3;
}

void  Drv_Uart0StartTx( unsigned char TxLength)
{
	DrvUart0Format.TxLength = TxLength;
	// Start TX
	DrvUart0Format.flag.b.IsBusyTx = 1;// uart 忙碌
	DrvUart0Format.TxBufoffset = 0;	// 因為0已經直接發送了
	_acc = _u0sr;
	_txr_rxr0 = DrvUart0Format.TxBuf[0];
}

void Drv_UART1_Init()
{
	SET_UARTn_Format_D8_NONE_S1(1); // 數據傳輸格式設定
	SET_UARTn_BAUDRATE_9600(1);	// 波特率設定
	SET_UARTn_FIFO_BYTE_1(1);
	SET_UARTn_ADDRESS_DISABLE(1);
	SET_UARTn_RECEIVER_IE_ENABLE(1);
	SET_UARTn_TRANSMITTER_IE_ENABLE(1);
	SET_UARTn_TRANSMITTER_EMPTY_ENABLE(1);
	SET_UARTn_ENABLE(1);
	_emi = 1;
	// UART IO
	SET_PF6_RX1();
	SET_PF7_TX1();
	DrvUart1Format.RxLength = 2;
}

void  Drv_Uart1StartTx( unsigned char TxLength)
{
	DrvUart1Format.TxLength = TxLength;
	// Start TX
	DrvUart1Format.flag.b.IsBusyTx = 1;// uart 忙碌
	DrvUart1Format.TxBufoffset = 0;	// 因為0已經直接發送了
	_acc = _u1sr;
	_txr_rxr1 = DrvUart1Format.TxBuf[0];
}

DEFINE_ISR(USIM0_ISR, 0x03C)
{
	if(_ur0f==1)
	{
		_ur0f = 0;
		// 奇偶校驗出錯
		// if (_perr0)
		// {
		// 	_acc = _usr;
		// 	_acc = _txr_rxr;
		// }
		// 錯誤處理
		if (_nf0 | _ferr0 | _oerr0)	//  噪聲干擾錯誤 |幀錯誤| 溢出錯誤
		{
			_acc = _u0sr;
			_acc = _txr_rxr0;
			DrvUart0Format.RxBufoffset = 0;
		}
		// 發送數据
		if (_txif0 && DrvUart0Format.flag.b.IsBusyTx)
		{
			// 數據幀發送完成判斷
		/*	while(!Txfinish_flag)
			{*/
				DrvUart0Format.TxBufoffset++;
				if ( DrvUart0Format.TxBufoffset < DrvUart0Format.TxLength)
				{
					_txr_rxr0 = DrvUart0Format.TxBuf[DrvUart0Format.TxBufoffset];
				}
				else
				{
					if (_tidle0)
					{
						Txfinish_flag=1;
						DrvUart0Format.flag.b.IsBusyTx = 0;
					}
				}
		//	}
		}
		// 接收數据
		if (_rxif0)
		{
			do 
			{
				DrvUart0Format.RxBuf[DrvUart0Format.RxBufoffset] = _txr_rxr0;
				DrvUart0Format.RxTimeOutCnt = 0;
		        DrvUart0Format.RxBufoffset++;				
			}while(_rxcnt0 > 0);
			
	        // 用戶需要在此寫Rx數據長度
	        // 1 固定長度,則在初始化的時候初始化話lu8v_RxBufLength
	
	        // 2 協議自帶長度信息
	        // if (DrvUart0Format.RxBufoffset == 3)
	        // {
	        // 	DrvUart0Format.RxLength = DrvUart0Format.RxBuf[2];
	        // }
	
	        if (DrvUart0Format.RxBufoffset >= DrvUart0Format.RxLength)
	        {
	            DrvUart0Format.RxBufoffset = 0;
	            DrvUart0Format.RxLength = 3;
	            DrvUart0Format.flag.b.IsRxSuccess = 1;
	        }
		}
	}
	
	else if(_ur1f==1)
	{
		_ur1f = 0;
		// 奇偶校驗出錯
		// if (_perr0)
		// {
		// 	_acc = _u1sr;
		// 	_acc = _txr_rxr1;
		// }
		// 錯誤處理
		if (_nf1 | _ferr1 | _oerr1)	//  噪聲干擾錯誤 |幀錯誤| 溢出錯誤
		{
			_acc = _u1sr;
			_acc = _txr_rxr1;
			DrvUart1Format.RxBufoffset = 0;
		}
		// 發送數据
		if (_txif1 && DrvUart1Format.flag.b.IsBusyTx)
		{
			// 數據幀發送完成判斷
			DrvUart1Format.TxBufoffset++;
			if ( DrvUart1Format.TxBufoffset < DrvUart1Format.TxLength)
			{
				_txr_rxr1 = DrvUart1Format.TxBuf[DrvUart1Format.TxBufoffset];
			}
			else
			{
				if (_tidle1)
				{
					DrvUart1Format.flag.b.IsBusyTx = 0;
				}
			}
		}
		// 接收數据
		if (_rxif1)
		{
			do 
			{
				DrvUart1Format.RxBuf[DrvUart1Format.RxBufoffset] = _txr_rxr1;
				DrvUart1Format.RxTimeOutCnt = 0;
		        DrvUart1Format.RxBufoffset++;				
			}while(_rxcnt1 > 0);
			
	        // 用戶需要在此寫Rx數據長度
	        // 1 固定長度,則在初始化的時候初始化話lu8v_RxBufLength
	
	        // 2 協議自帶長度信息
	        // if (DrvUart1Format.RxBufoffset == 3)
	        // {
	        // 	DrvUart1Format.RxLength = DrvUart1Format.RxBuf[2];
	        // }
	
	        if (DrvUart1Format.RxBufoffset >= DrvUart1Format.RxLength)
	        {
	            DrvUart1Format.RxBufoffset = 0;
	            DrvUart1Format.RxLength = 2;
	            DrvUart1Format.flag.b.IsRxSuccess = 1;
	        }
		}
	}
}


#define UART_OK		0x00;
#define UART_OVER	0x02;

/**
 * @brief 將字符串寫入TxBuf
 *
 * @param src string字符串
 * @param startaddr  tx buf開始地址
 * @param len	字符串長度
 * @return unsigned char
 */
unsigned char Drv_UART0WriteTxBuf(char* src,unsigned char startaddr, unsigned char len)
{
	if (len+startaddr > UART_LENGTH_TX)
	{
		return UART_OVER;
	}
	else
	{
		unsigned char i;
		for ( i = startaddr; i < len; i++)
		{
			DrvUart0Format.TxBuf[i] = *src++;
		}
		return UART_OK;
	}
}

/**
 * @brief 將字符串寫入TxBuf
 *
 * @param src string字符串
 * @param startaddr  tx buf開始地址
 * @param len	字符串長度
 * @return unsigned char
 */
unsigned char Drv_UART1WriteTxBuf(char* src,unsigned char startaddr, unsigned char len)
{
	if (len+startaddr > UART_LENGTH_TX)
	{
		return UART_OVER;
	}
	else
	{
		unsigned char i;
		for ( i = startaddr; i < len; i++)
		{
			DrvUart1Format.TxBuf[i] = *src++;
		}
		return UART_OK;
	}
}